<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\MyLog;
use App\Models\Admin\Variant;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Lang;


class VariantController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $inputs = Input::get();

        if (isset($inputs['pagination_per_page']))
            return Variant::paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return Variant::paginate();
        else if (!isset($inputs['pagination_per_page']) && !isset($inputs['page']))
            return Variant::all();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $warning = null;
        $variant_stored = Variant::where('ERP_code', $request->ERP_code)->first();
        if ($variant_stored != null)
            $warning = 'variant_already_exists_ERP_code';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $variant = new Variant;
        $inputs = $request->all();
        foreach ($inputs as $key => $value) {
            $variant[$key] = $value;
        }
        $variant->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return Variant::findOrFail($id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $variant = Variant::findOrFail($id);
        $warning = null;

        if (Input::has('ERP_code'))
            $variant->ERP_code = Input::get('ERP_code');
        $variants_stored = Variant::where('ERP_code', $variant->ERP_code);
        $variants_stored_count = $variants_stored->count();
        if ($variants_stored_count == 1) {
            if ($variant->id != $variants_stored->first()->id)
                $warning = 'variant_already_exists_ERP_code';
        }
        else if ($variants_stored_count > 1)
            $warning = 'variant_already_exists_ERP_code';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $inputs = $request->all();
        foreach ($inputs as $key => $value) {
            $variant[$key] = $value;
        }
        $variant->save();
    }

}
