<?php

namespace App\Http\Controllers\Api\ERP\V1_0;

use App\Http\Controllers\Controller;
use App\Models\ERP\Command;
use App\Http\Utils\MyLog;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Validator;
use Log;

class CommandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $commands = Command::where('received', 0)->where(function($query){
                        $query->where('status_id', 10)->orWhere('status_id', 20);
                    })->with('items')->get();
        foreach($commands as $command) {
            $command->delivery;
        }
        return $commands;
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $command = Command::findOrFail($id);
        $command->items;
        $command->delivery;

        return $command;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $commands_failled = DB::transaction(function () use ($request) {
            $results = [];

            if ($request->has('parameters')) {
                foreach ($request->parameters as $element) {
                    $validator = Validator::make($element, [
                        'number' => 'required|string|size:20',
                        'received' => 'integer',
                        'status_id' => 'integer',
                        'ERP_code' => 'string'
                    ]);
                    if ($validator->fails()) {
                        $status = 400;
                        $error = 'validation_error';
                        $messages = $validator->errors()->all();
                        MyLog::Error($status, $error, null, null, $messages, $element);
                        array_push($results, $element);
                        continue;
                    }

                    $number = null;
                    $received = null;
                    $status_id = null;
                    $ERP_code = null;
                    if (isset($element['number']))
                        $number = $element['number'];
                    if (isset($element['received']))
                        $received = $element['received'];
                    if (isset($element['status_id']))
                        $status_id = $element['status_id'];
                    if (isset($element['ERP_code']))
                        $ERP_code = $element['ERP_code'];

                        // If non of received nor status_id are present or
                    if (($received == null && $status_id == null) ||
                        // If both received and (status_id or $ERP_code) are present or
                        ($received != null && ($status_id != null || $ERP_code != null)) ||
                        // If the status_id corresponds to  30, 'Prise en compte',  then the ERP_code should be present
                         ($status_id == 30 && $ERP_code == null)) {
                        // then log an error and skip the current command
                        $status = 400;
                        $error = 'validation_error';
                        $message = Lang::get('messages.parameters_inconsistency');
                        MyLog::Error($status, $error, $message, null, null, null, $element);
                        array_push($results, $element);
                        continue;
                    }

                    // Command information storage
                    $query = Command::where('number', $number);
                    $nbCommands = $query->count();
                    if ($nbCommands != 0) {
                        $command = $query->first();

                        // If the target status is not 30 (Prise en compte) and the command is not marked as 'reveived',
                        // then log and error an skip the current command
                        if (($status_id > 30 && $command->received == '0')) {
                            // then log an error and skip the current command
                            $status = 400;
                            $error = 'validation_error';
                            $message = Lang::get('messages.parameters_inconsistency');
                            MyLog::Error($status, $error, $message, null, null, null, $element);
                            array_push($results, $element);
                            continue;
                        }

                        if ($received != null) {
                            $command['received'] = $received;
                            $command->save();
                        }
                        else if ($status_id != null && $ERP_code != null) {
                            $command['status_id'] = $status_id;
                            $command['ERP_code'] = $ERP_code;
                            $command->save();
                        }
                        // Traitée ou Annulée
                        else if ($status_id == 40 || $status_id == 50) {
                            $command['status_id'] = $status_id;
                            $command->save();
                        }
                    }
                    else {
                        $status = 400;
                        $error = 'validation_error';
                        $message = Lang::get('messages.command_not_found');
                        MyLog::Error($status, $error, $message, null, null, null, $element);
                        array_push($results, $element);
                        continue;
                    }
                }
            }

            return $results;
        });


        return response()->json(['commands_failled' => $commands_failled], 200);
    }
}
