<?php
/**
 * Created by PhpStorm.
 * User: KBM-Adil_Zaid
 * Date: 11/04/2017
 * Time: 14:38
 */

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Models\Constant;
use App\Models\Users\Individuals\Category;
use Log;
use Illuminate\Support\Facades\Hash;
use App\Http\Utils\Miscellaneous;


class CatalogController
{
    /**
     * Display the whole catalog at once.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $categories = Category::where(['deactivated' => 0, 'visible_individual' => 1])->
                            has('groups')->
                            with('groups','groups.products', 'groups.pictures', 'groups.products.unit', 'groups.products.type', 'groups.products.vat', 'groups.products.variants')->
                            get();

        return response()->json(['version' => $this->version(), 'categories' => $categories], 200);
    }

    /**
     * Display the catalog version.
     *
     * @return \Illuminate\Http\Response
     */
    public function version()
    {
        //
        return Miscellaneous::getVersion();
    }
}
