<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0\Command;

use App\Models\Users\Individuals\Item;
use Log;

class CommandDecorator
{
    private $command = null;
    private $items = null;

    public function __construct($command)
    {
        $this->command = $command;
        $this->items = array();
    }

    public function decorate($inputItems)
    {
        // Calculate de command TTC price
        foreach ($inputItems as $inputItem) {
            $item = new Item();
            $itemDecorator = new ItemDecorator($item);
            $itemDecorator->decorate($inputItem);
            array_push($this->items, $item);
        }

        $this->command->total_ttc = $this->calculateTotalTTC();
        $this->command->total_ht = $this->calculateTotalHT();
        $this->command->total_vat = $this->calculateTotalTVA();
    }

    public function getItems() {
        return $this->items;
    }

    private function calculateTotalTTC(){
        $totalTTC = 0;
        foreach ($this->items as $item)
            $totalTTC += $item->total_ttc;

        if ($totalTTC != $this->command->total_ttc)
            Log::warning('Command total TTC should be equal to '.$totalTTC.' whereas total TTC '. $this->command->total_ttc.' received');

        return $totalTTC;
    }

    private function calculateTotalHT(){
        $totalHT = 0;
        foreach ($this->items as $item)
            $totalHT += $item->total_ht;

        if ($totalHT != $this->command->total_ttc)
            Log::warning('Command total HT should be equal to '.$totalHT.' whereas total ttc '. $this->command->total_ht.' received');

        return $totalHT;
    }

    private function calculateTotalTVA(){
        $totalTVA = 0;
        foreach ($this->items as $item)
            $totalTVA += $item->total_tva;

        if ($totalTVA != $this->command->total_ttc)
            Log::warning('Command total TVA should be equal to '.$totalTVA.' whereas total ttc '. $this->command->total_vat.' received');

        return $totalTVA;
    }
}