<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Resellers\Product;
use Illuminate\Support\Facades\Auth;


class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $user = Auth::user();
        $client_id = $user->reseller->client_id;
        return Product::where('specific_client_id', null)->OrWhere('specific_client_id', $client_id)->get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return Product::with('group', 'group.pictures', 'unit', 'type', 'vat', 'variants')->findOrFail($id);
    }

}
