<?php

namespace App\Http\Middleware;

use App\Http\Utils\MyLog;
use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;

class Admin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ( Auth::check() && Auth::user()->isAdmin() )
        {
            return $next($request);
        }
        else {
            $status = 403;
            $error = 'not_admin';
            $message = Lang::get('messages.' . $error);
            MyLog::Error($status, $error, $message);
            return response()->json(['error' => $error, 'message' => $message], $status);
        }
    }
}
