<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;

class Reseller extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'deactivated', 'price_visibility', 'company_id', 'user_id', 'client_id', 'first_name', 'last_name', 'mobile', 'company'];

    /**
     * The attributes that should be appended to arrays.
     *
     * @var array
     */
    protected $appends = ['phone', 'full_name', 'email', 'adress', 'adress_followup', 'town'];

    /**
     * Get the client that this reseller belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\ERP\Client');
    }

    /**
     * Get the user that this reseller belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the company that belongs to this reseller.
     */
    public function company()
    {
        return $this->belongsTo('App\Models\ERP\ResellerCompany');
    }

    /**
     * Get the calculated reseller's phone.
     */
    public function getPhoneAttribute() {
        return $this->mobile;
    }

    /**
     * Get the calculated reseller's name.
     */
    public function getFullNameAttribute() {
        return $this->last_name . ' ' . $this->first_name;
    }


    /**
     * Get the the calculated email.
     */
    public function getEmailAttribute() {
        return $this->company->email;
    }

    /**
     * Get a fake reseller's adress.
     */
    public function getAdressAttribute() {
        return null;
    }

    /**
     * Get a fake reseller's adress.
     */
    public function getAdressFollowupAttribute() {
        return null;
    }

    /**
     * Get a fake reseller's adress.
     */
    public function getTownAttribute() {
        return null;
    }

}
