<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;

class ResellerCompany extends Model
{
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'client_id'];

    /**
     * Get the client that this reseller belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\ERP\Client');
    }

    /**
     * The discount of this company reseller.
     */
    public function discounts()
    {
        return $this->client->discounts();
    }

    /**
     * The resellers of this company reseller.
     */
    public function resellers()
    {
        return $this->hasMany('App\Models\ERP\Reseller', 'company_id');
    }
}
