<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at'];

    /**
     * Get the individuals that belongs to this client.
     */
    public function resellers()
    {
        return $this->hasMany('App\Models\Admin\Reseller');
    }

    /**
     * Get the individuals that belongs to this client.
     */
    public function individuals()
    {
        return $this->hasMany('App\Models\Admin\Individual');
    }

    /**
     * The discount of this client.
     */
    public function discounts()
    {
        return $this->belongsToMany('App\Models\Admin\Discount')->withPivot('rate')->where('deactivated', 0);
    }
}
