<?php

namespace App\Models\Users\Individuals;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'groups_individuals';

    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual', 'category_id'];

    /**
     * Get the category that the group belongs to.
     */
    public function category()
    {
        return $this->belongsTo('App\Models\Users\Individuals\Category');
    }

    /**
     * Get the products that belongs to this group.
     */
    public function products()
    {
        return $this->hasMany('App\Models\Users\Individuals\Product');
    }

    /**
     * The Pictures associated to this Group.
     */
    public function pictures()
    {
        return $this->hasMany('App\Models\Picture');
    }
}
