<?php

namespace App\Models\Users\Individuals;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'products_individuals';

    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual', 'group_id', 'unit_id', 'type_id', 'vat_id', 'discount_id', 'specific_client_id'];

    protected $appends = ['dimensions'];

    /**
     * Get the Type Unit that owns the Product.
     */
    public function unit()
    {
        return $this->belongsTo('App\Models\Users\Unit');
    }

    /**
     * Get the Type Type that owns the Product.
     */
    public function type()
    {
        return $this->belongsTo('App\Models\Type');
    }

    /**
     * Get the Type Vat that owns the Product.
     */
    public function vat()
    {
        return $this->belongsTo('App\Models\Users\Vat');
    }

    /**
     * Get the Product Group that product belongs to.
     */
    public function group()
    {
        return $this->belongsTo('App\Models\Users\Individuals\Group');
    }

    /**
     * The Variants associated to this Product.
     */
    public function variants()
    {
        return $this->belongsToMany('App\Models\Users\Variant')->where('deactivated', 0);
    }

    /**
     * The Dimensions to display for this Product.
     */
    public function getDimensionsAttribute()
    {
        // Pièce
        if ($this->unit_id == 1) {
            $dimensions = ($this->length * 100). ' x ' . ($this->width * 100);
            if ($this->type != null)
                $dimensions .= ' - ' . $this->type->name;
            return $dimensions;
        }
        // ML
        else if ($this->unit_id == 2) {
            $dimensions = ($this->width * 100). ' x ' . ($this->high * 100);
            if ($this->type != null)
                $dimensions .= ' - ' . $this->type->name;
            return $dimensions;
        }
        // M3
        else {
            return null;
        }
    }
}
