<?php

namespace App\Models\Users\Resellers;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'groups';

    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual', 'category_id'];

    /**
     * Get the category that the group belongs to.
     */
    public function category()
    {
        return $this->belongsTo('App\Models\Users\Resellers\Category');
    }

    /**
     * Get the products that belongs to this group.
     */
    public function products()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->with('unit', 'type', 'vat', 'variants');
    }

    /**
     * Get the specific products that belongs to this group.
     */
    public function specificProducts()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->with('unit', 'type', 'vat', 'variants');
    }

    /**
     * Get the standard products that belongs to this group.
     */
    public function standardProductsCondition()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->where('deactivated', 0)
                    ->where('non_standard', 0)
                    ->whereNull('specific_client_id');
    }


    /**
     * Get the standard products that belongs to this group.
     */
    public function standardProducts()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->with('unit', 'type', 'vat', 'variants');
    }

    /**
     * Get the non standard products that belongs to this group.
     */
    public function nonStandardProductsCondition()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->where('deactivated', 0)
                    ->where('non_standard', 1)
                    ->whereNull('specific_client_id');
    }

    /**
     * Get the non standard products that belongs to this group.
     */
    public function nonStandardProducts()
    {
        return $this->hasMany('App\Models\Users\Resellers\Product')
                    ->with('unit', 'type', 'vat', 'variants');
    }

    /**
     * Get the standard products that belongs to this group.
     */
    public function favouriteProductsCondition()
    {
        return $this->standardProductsCondition();
    }


    /**
     * Get the standard products that belongs to this group.
     */
    public function favouriteProducts()
    {
        return $this->standardProducts();
    }

    /**
     * The Pictures associated to this Group.
     */
    public function pictures()
    {
        return $this->hasMany('App\Models\Picture');
    }
}
