<!DOCTYPE html>
<html lang="fr">
<head>
    <title>Confirmation de la commande</title>
    <style>
        .sumuptable {
            border: 1px solid black;
            border-collapse: collapse;
            margin: 0 auto;
            width: 60%;
            font-size: 21px;
        }
        .itemstable {
            border: 1px solid black;
            border-collapse: collapse;
            width: 100%;
            font-size: 18px;
        }
        .deliverytable {
            border: 1px solid black;
            border-collapse: collapse;
            margin-right: 0px;
            width: 40%;
            font-size: 20px;
        }
        .totaltable {
            border: 1px solid black;
            border-collapse: collapse;
            margin-right: 0px;
            margin-left: auto;
            width: 20%;
            font-size: 21px;
        }
        th {
            border: 1px solid black;
            border-collapse: collapse;
        }
        th {
            border: 1px solid black;
            border-collapse: collapse;
        }
        .td_sumup {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        .td_number {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: right;
        }
        .td_name {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: left;
        }
        .td_string {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        .td_delivery {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        div {
            left: 0;
            top: 0;
            text-align: center;
            font-size: 22px;
            font-weight: bold;
        }
        .container {
            width:1200px;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <br>
        <br>
        <br>
        <div>Votre commande N° {{$command->number}} @if ($command->status_id == 1)  est en attente de paiement @elseif ($command->status_id >= 20 && $command->status_id != 50) est confirmée @endif</div>
        <br>
        <br>
        <br>
        <table class="sumuptable">
            <tr>
                <th>Numéro commande</th>
                <th>Date commande</th>
                <th>Statut</th>
            </tr>
            <tr>
                <td class="td_sumup">{{$command->number}}</td>
                <td class="td_sumup">{{$command->created_at->format('d-m-Y')}}
                <td class="td_sumup">{{$command->status->name}}</td>
            </tr>
        </table>
        <br>
        <br>
        <table class="itemstable">
            <tr>
                <th>Produit</th>
                <th>Variante</th>
                <th>Prix unitaire TTC</th>
                <th>Longueur</th>
                <th>Quantité</th>
                <th>Remise %</th>
                <th>Total TTC</th>
            </tr>
            @foreach ($command->items as $item)
                <tr>
                    <td class="td_name">{{$item->product_name}}</td>
                    <td class="td_string">{{$item->variant_ERP_code}}</td>
                    <td class="td_number">{{number_format($item->product_price_ttc, 2, ',', ' ')}}</td>
                    @if ($item->saisir_longueur==1 && $item->length != null)
                        <td class="td_number">{{number_format($item->length, 2, ',', ' ')}}</td>
                    @else
                        <td class="td_string">-</td>
                    @endif
                    <td class="td_number">{{$item->quantity}}</td>
                    @if ($item->discount_rate != null)
                        <td class="td_number">{{$item->discount_rate}}</td>
                    @else
                        <td class="td_string">-</td>
                    @endif
                    <td class="td_number">{{$item->ttc_total}}</td>
                </tr>
            @endforeach
        </table>
        <br>
        <table  class="totaltable">
            <tr class>
                <th>Prix Total TTC</th>
            </tr>
            <tr>
                <td class="td_number">{{$command->ttc_total}}</td>
            </tr>
        </table>
        <br>
        <table  class="deliverytable">
            <tr>
                <th>Adresse de livraison</th>
            </tr>
            <tr>
                <td class="td_delivery">@if($command->delivery->company_name!=null){{$command->delivery->company_name}}<br>@endif {{$command->delivery->last_name}} {{$command->delivery->first_name}}<br>{{$command->delivery->adress}}<br>@if($command->delivery->adress_followup){{$command->delivery->adress_followup}}<br>@endif{{$command->delivery->town}}<br>{{$command->delivery->phone}}</td>
            </tr>
        </table>
        </div>
    </body>
</html>
