<!DOCTYPE html>
<html lang="fr">
<head>
    <title>Confirmation de la commande</title>
    <style>
        .sumuptable {
            border: 1px solid black;
            border-collapse: collapse;
            margin: 0 auto;
            width: 60%;
            font-size: 21px;
        }
        .itemstable {
            border: 1px solid black;
            border-collapse: collapse;
            width: 100%;
            font-size: 18px;
        }
        .deliverytable {
            border: 1px solid black;
            border-collapse: collapse;
            margin-right: 0px;
            width: 40%;
            font-size: 20px;
        }
        .totaltable {
            border: 1px solid black;
            border-collapse: collapse;
            margin-right: 0px;
            margin-left: auto;
            width: 20%;
            font-size: 21px;
        }
        th {
            border: 1px solid black;
            border-collapse: collapse;
        }
        th {
            border: 1px solid black;
            border-collapse: collapse;
        }
        .td_sumup {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        .td_number {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: right;
        }
        .td_name {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: left;
        }
        .td_string {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        .td_delivery {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }
        div {
            left: 0;
            top: 0;
            text-align: center;
            font-size: 22px;
            font-weight: bold;
        }
        .container {
            width:1200px;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <br>
        <br>
        <br>
        <div>Votre commande N° <?php echo e($command->number); ?> <?php if($command->status_id == 1): ?>  est en attente de paiement <?php elseif($command->status_id >= 20 && $command->status_id != 50): ?> est confirmée <?php endif; ?></div>
        <br>
        <br>
        <br>
        <table class="sumuptable">
            <tr>
                <th>Numéro commande</th>
                <th>Date commande</th>
                <th>Statut</th>
            </tr>
            <tr>
                <td class="td_sumup"><?php echo e($command->number); ?></td>
                <td class="td_sumup"><?php echo e($command->created_at->format('d-m-Y')); ?>

                <td class="td_sumup"><?php echo e($command->status->name); ?></td>
            </tr>
        </table>
        <br>
        <br>
        <table class="itemstable">
            <tr>
                <th>Produit</th>
                <th>Variante</th>
                <th>Prix unitaire TTC</th>
                <th>Longueur</th>
                <th>Quantité</th>
                <th>Remise %</th>
                <th>Total TTC</th>
            </tr>
            <?php $__currentLoopData = $command->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                <tr>
                    <td class="td_name"><?php echo e($item->product_name); ?></td>
                    <td class="td_string"><?php echo e($item->variant_ERP_code); ?></td>
                    <td class="td_number"><?php echo e(number_format($item->product_price_ttc, 2, ',', ' ')); ?></td>
                    <?php if($item->saisir_longueur==1 && $item->length != null): ?>
                        <td class="td_number"><?php echo e(number_format($item->length, 2, ',', ' ')); ?></td>
                    <?php else: ?>
                        <td class="td_string">-</td>
                    <?php endif; ?>
                    <td class="td_number"><?php echo e($item->quantity); ?></td>
                    <?php if($item->discount_rate != null): ?>
                        <td class="td_number"><?php echo e($item->discount_rate); ?></td>
                    <?php else: ?>
                        <td class="td_string">-</td>
                    <?php endif; ?>
                    <td class="td_number"><?php echo e($item->ttc_total); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
        </table>
        <br>
        <table  class="totaltable">
            <tr class>
                <th>Prix Total TTC</th>
            </tr>
            <tr>
                <td class="td_number"><?php echo e($command->ttc_total); ?></td>
            </tr>
        </table>
        <br>
        <table  class="deliverytable">
            <tr>
                <th>Adresse de livraison</th>
            </tr>
            <tr>
                <td class="td_delivery"><?php if($command->delivery->company_name!=null): ?><?php echo e($command->delivery->company_name); ?><br><?php endif; ?> <?php echo e($command->delivery->last_name); ?> <?php echo e($command->delivery->first_name); ?><br><?php echo e($command->delivery->adress); ?><br><?php if($command->delivery->adress_followup): ?><?php echo e($command->delivery->adress_followup); ?><br><?php endif; ?><?php echo e($command->delivery->town); ?><br><?php echo e($command->delivery->phone); ?></td>
            </tr>
        </table>
        </div>
    </body>
</html>
