<!DOCTYPE html>
<html lang="fr">
    <head>
        <title>Confirmation de la commande</title>
        <style>
            .sumuptable {
                border: 1px solid black;
                border-collapse: collapse;
                margin: 0 auto;
                width: 60%;
                font-size: 110%;
            }
            .itemstable {
                border: 1px solid black;
                border-collapse: collapse;
                width: 100%;
                font-size: 100%;
            }
            .deliverytable {
                border: 1px solid black;
                border-collapse: collapse;
                margin-right: 0px;
                width: 60%;
                font-size: 110%;
            }
            .totaltable {
                border: 1px solid black;
                border-collapse: collapse;
                margin-right: 0px;
                margin-left: auto;
                width: 40%;
                font-size: 110%;
            }
            th, td {
                border: 1px solid black;
                border-collapse: collapse;
            }
            div {
                left: 0;
                top: 0;
                text-align: center;
                font-size: 130%;
            }
        </style>
    </head>
    <body>
        <div>Détail de votre commande</div>
        <br>
        <br>
        <br>
        <table class="sumuptable">
            <tr>
                <th>Numéro commande</th>
                <th>Date commande</th>
                <th>Statut</th>
            </tr>
            <tr>
                <td><?php echo e($command->number); ?></td>
                <td><?php echo e($command->created_at->format('d-m-Y')); ?>

                <td><?php echo e($command->status->name); ?></td>
            </tr>
         </table>
        <br>
        <br>
        <table class="itemstable">
                <tr>
                    <th>Produit</th>
                    <th>Variante</th>
                    <th>Prix unitaire TTC</th>
                    <th>Longueur</th>
                    <th>Quantité</th>
                    <th>Remise %</th>
                    <th>Total TTC</th>
                </tr>
                <?php $__currentLoopData = $command->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                <tr>
                    <td><?php echo e($item->product_name); ?></td>
                    <td><?php echo e($item->variant_ERP_code); ?></td>
                    <td><?php echo e(number_format($item->product_price_ttc, 2, ',', ' ')); ?></td>
                    <?php if($item->length != null): ?>
                        <td><?php echo e(number_format($item->length, 2, ',', ' ')); ?></td>
                    <?php else: ?>
                        <td>-</td>
                    <?php endif; ?>
                        <td><?php echo e($item->quantity); ?></td>
                    <?php if($item->discount_rate != null): ?>
                        <td><?php echo e($item->discount_rate); ?></td>
                    <?php else: ?>
                        <td>-</td>
                    <?php endif; ?>
                     <td><?php echo e($item->ttc_total); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
            </table>
        <br>
        <table  class="totaltable">
            <tr class>
                <th>Prix Total TTC</th>
            </tr>
            <tr>
                <td><?php echo e($command->ttc_total); ?></td>
            </tr>
        </table>
        <br>
        <table  class="deliverytable">
            <tr>
                <th>Adresse de livraison</th>
            </tr>
            <tr>
                <td><?php echo e($command->delivery->last_name); ?> <?php echo e($command->delivery->first_name); ?><br><?php echo e($command->delivery->adress); ?> <?php echo e($command->delivery->adress_followup); ?> <?php echo e($command->delivery->town); ?><br><?php echo e($command->delivery->phone); ?></td>
            </tr>
        </table>
    </body>
</html>
