<?php

namespace App\Exceptions;

use App\Http\Utils\MyLog;
use Exception;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Support\Facades\Lang;
use League\OAuth2\Server\Exception\OAuthServerException;
use PDOException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that should not be reported.
     *
     * @var array
     */
    protected $dontReport = [
        \Illuminate\Auth\AuthenticationException::class,
        \Illuminate\Auth\Access\AuthorizationException::class,
        \Symfony\Component\HttpKernel\Exception\HttpException::class,
        \Illuminate\Database\Eloquent\ModelNotFoundException::class,
        \Illuminate\Session\TokenMismatchException::class,
        \Illuminate\Validation\ValidationException::class,
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param  \Exception $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        $status = null;
        $error = null;
        $exceptionMessage = null;

        if ($exception instanceof OAuthServerException) {
            if ($exception->getErrorType() == 'invalid_credentials') {
                MyLog::error($exception->getHttpStatusCode(), $exception->getErrorType(), Lang::get('messages.'.$exception->getErrorType()), $exception->getMessage());
            }
            else {
                MyLog::error($exception->getHttpStatusCode(), $exception->getErrorType(), $exception->getMessage(), $exception->getMessage());
            }
        }
        else if ($exception instanceof PDOException) {
            MyLog::Error(500, 'unexpected_error', Lang::get('messages.unexpected_error'), $exception->getMessage());
        }
        else {
            parent::report($exception);
        }
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Exception $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        $status = null;
        $error = null;

        if ($exception instanceof OAuthServerException) {
            if ($exception->getErrorType() == 'invalid_credentials') {
                return response()->json(['error' => $exception->getErrorType(), 'message' => Lang::get('messages.'.$exception->getErrorType())], $exception->getHttpStatusCode());
            }
            else {
                return response()->json(['error' => $exception->getErrorType(), 'message' => $exception->getMessage()], $exception->getHttpStatusCode());
            }
        }
        else if ($exception instanceof PDOException) {
            return response()->json(['error' => 'unexpected_error', 'message' => Lang::get('messages.unexpected_error')], 409);
        }
        else {
            return parent::render($request, $exception);
        }
    }

    /**
     * Convert an authentication exception into an unauthenticated response.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Illuminate\Auth\AuthenticationException $exception
     * @return \Illuminate\Http\Response
     */
    protected function unauthenticated($request, AuthenticationException $exception)
    {
        //if ($request->expectsJson()) {
            MyLog::error(401, 'Unauthenticated.', null, $exception->getMessage());
            return response()->json(['error' => 'unauthenticated.', 'message' => Lang::get('messages.unauthenticated')], 401);
        //}

        //return redirect()->guest('login');
    }
}
