<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Admin\Command;
use DB;
use Illuminate\Support\Facades\Input;

class CommandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $query = Command::query();

        $inputs = Input::get();
        foreach ($inputs as $key => $value) {
            if ($key == 'start') {
                $startDate = Input::get('start') . ' ' . '00:00:00';
                $query->where('commands.created_at', '>=', $startDate);
            }
            elseif ($key == 'end') {
                $endDate = Input::get('end') . ' ' . '23:59:59';
                $query->where('commands.created_at', '<=', $endDate);
            }
            elseif ($key == 'customer_name')
                $query->leftJoin('individuals', 'individuals.id', 'commands.individual_id')
                      ->leftJoin('resellers', 'resellers.id', 'commands.reseller_id')
                      ->leftJoin('reseller_companies', 'reseller_companies.id', 'resellers.company_id')
                      ->where('individuals.first_name', 'like', '%'.$value.'%')
                      ->orWhere('individuals.last_name', 'like', '%'.$value.'%')
                      ->orWhere('reseller_companies.name', 'like','%'.$value.'%')
                      ->orWhere('resellers.first_name', 'like','%'.$value.'%')
                      ->orWhere('resellers.last_name', 'like','%'.$value.'%');
            elseif ($key == 'number' || $key == 'ERP_code')
                $query->where('commands.'.$key, 'like' , '%'.$value.'%');
            else if ($key != 'page' && $key != 'pagination_per_page')
                $query->where('commands.'.$key, $value);
        }

        $query->select('commands.*')->with('type', 'status', 'client', 'channel', 'individual', 'individual.user', 'individual.town', 'reseller', 'reseller.user', 'reseller.company');
        $query->orderBy('id', 'desc');

        if (isset($inputs['pagination_per_page']))
            return $query->paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return $query->paginate();
        else
            return $query->get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $command = Command::findOrFail($id);
        $command->type;
        $command->channel;
        $command->status;
        $command->client;
        $command->individual;
        if ($command->individual != null) {
            $command->individual->user;
            $command->individual->town;
        }
        $command->reseller;
        if ($command->reseller != null) {
            $command->reseller->user;
            $command->reseller->company;
        }
        $command->delivery;
        $command->items;

        return $command;
    }
}
