<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\MyLog;
use App\Http\Utils\Miscellaneous;
use App\Models\Admin\Discount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Input;
use DB;


class DiscountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $inputs = Input::get();

        if (isset($inputs['pagination_per_page']))
            return Discount::paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return Discount::paginate();
        else if (!isset($inputs['pagination_per_page']) && !isset($inputs['page']))
            return Discount::all();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $warning = null;
        $discount_stored = Discount::where('ERP_group_code', $request->ERP_group_code)->first();
        if ($discount_stored != null)
            $warning = 'discount_already_exists_ERP_code';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $discount = new Discount();
        $inputs = $request->all();
        DB::transaction(function () use ($discount, $inputs) {
            foreach ($inputs as $key => $value) {
                $discount[$key] = $value;
            }
            $discount->save();
            Miscellaneous::incrementVersion();
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return Discount::findOrFail($id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //;
        $discount = Discount::findOrFail($id);
        $warning = null;

        if (Input::has('ERP_group_code'))
            $discount->ERP_group_code = Input::get('ERP_group_code');
        $discounts_stored = Discount::where('ERP_group_code', $discount->ERP_group_code);
        $discounts_stored_count = $discounts_stored->count();
        if ($discounts_stored_count == 1) {
            if ($discount->id != $discounts_stored->first()->id)
                $warning = 'discount_already_exists_ERP_code';
        }
        else if ($discounts_stored_count > 1)
            $warning = 'discount_already_exists_ERP_code';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $inputs = $request->all();
        DB::transaction(function () use ($discount, $inputs) {
            foreach ($inputs as $key => $value) {
                $discount[$key] = $value;
            }
            $discount->save();
            Miscellaneous::incrementVersion();
        });
    }

}
