<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\Miscellaneous;
use App\Models\Admin\Message;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;


class ResellerCommunicationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $startDate = null;
        $endDate = null;

        $query = Message::query();

        $inputs = Input::get();
        foreach ($inputs as $key => $value) {
            if ($key == 'start')
                $startDate = Input::get('start') . ' ' . '00:00:00';
            elseif ($key == 'end')
                $endDate = Input::get('end') . ' ' . '23:59:59';
            else if ($key != 'page' && $key != 'pagination_per_page')
                $query->where('messages.'.$key, $value);
        }

        if ($startDate != null && $endDate != null) {
            $query->where(function ($query1) use ($startDate,$endDate) {
                $query1->where(function ($query) use ($startDate) {
                    $query->where('messages.start_date', '<=', $startDate)
                        ->where('messages.end_date', '>=', $startDate);
                     })->orWhere(function ($query) use ($endDate) {
                        $query->where('messages.start_date', '<=', $endDate)
                        ->where('messages.end_date', '>=', $endDate);
                    })->orWhere(function ($query) use ($startDate,$endDate) {
                        $query->where('messages.start_date', '>=', $startDate)
                            ->where('messages.end_date', '<=', $endDate);
                    })->orWhere(function ($query) use ($startDate,$endDate) {
                        $query->where('messages.start_date', '<=', $startDate)
                            ->where('messages.end_date', '>=', $endDate);
                    })->orWhere(function ($query) use ($startDate) {
                        $query->whereNull('messages.start_date')
                              ->where('messages.end_date', '>=', $startDate);
                    })->orWhere(function ($query) use ($endDate) {
                        $query->where('messages.start_date', '<=', $endDate)
                              ->whereNull('messages.end_date');
                    })->orWhere(function ($query) {
                        $query->whereNull('messages.start_date')
                              ->whereNull('messages.end_date');
                    });
            });
        }
        else if ($startDate != null && $endDate == null) {
            $query->where(function ($query1) use ($startDate,$endDate) {
                $query1->where(function ($query) use ($startDate) {
                    $query->where('messages.end_date', '>=', $startDate);
                })->orWhere(function ($query){
                    $query->whereNull('messages.end_date');
                });
            });
        }
        else if ($startDate == null && $endDate != null){
            $query->where(function ($query1) use ($startDate,$endDate) {
                $query1->where(function ($query) use ($endDate) {
                    $query->where('messages.start_date', '<=', $endDate);
                })->orWhere(function ($query) use ($endDate) {
                    $query->whereNull('messages.start_date');
                });
            });
        }

        $query->with('client');
        $query->orderBy('client_id', 'asc')->orderBy('end_date', 'desc')->orderBy('start_date', 'desc');

        if (isset($inputs['pagination_per_page']))
            return $query->paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return $query->paginate();
        else
            return $query->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $message = new Message();
        $inputs = $request->all();
        DB::transaction(function () use ($message, $inputs) {
            foreach ($inputs as $key => $value) {
                $message[$key] = $value;
            }
            $message->save();
            Miscellaneous::incrementVersion();
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $message = Message::findOrFail($id);
        $message->client;

        return $message;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $message = Message::findOrFail($id);

        $inputs = $request->all();
        DB::transaction(function () use ($message, $inputs) {
            foreach ($inputs as $key => $value) {
                $message[$key] = $value;
            }
            $message->save();
            Miscellaneous::incrementVersion();
        });
    }
}
