<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0\Command;

use App\Models\Users\Individuals\Product;
use App\Models\Users\Variant;
use Log;


class ItemDecorator
{
    private $item = null;

    public function __construct($item)
    {
        $this->item = $item;
    }

    public function decorate($inputItem)
    {
        $this->fillProduct($inputItem);
        $this->fillVariant($inputItem);
        $product = Product::findOrFail($this->item->product_id);

        $this->fillQuantity($inputItem);
        $this->fillDimensionProperties($product,$inputItem);
        $this->fillOtherProperties($product);
        $this->item->total_ttc = $this->calculateTotalTTC($product);
        $this->item->total_ht = $this->calculateTotalHT($product);
        $this->item->total_tva = $this->calculateTotalTVA();
    }

    private function calculateTotalTTC($product)
    {
        $totalTTC = $this->item->quantity * (1 - ($product->discount_rate / 100)) * $product->price_ttc;

        if ($product->saisir_dim_supp_1 || $product->saisir_dim_supp_2 || $product->saisir_dim_supp_3 || $product->saisir_dim_supp_4 || $product->saisir_dim_supp_5)
            $totalTTC = 0;
        else {
            if ($product->saisir_longueur)
                $totalTTC *= $this->item->length;
            if ($product->saisir_largeur)
                $totalTTC *= $this->item->width;
            if ($product->saisir_hauteur)
                $totalTTC *= $this->item->high;
        }

        if ($totalTTC != $this->item->total_ttc)
            Log::warning('Item total TTC should be equal to '.$totalTTC.' whereas total TTC '. $this->item->total_ttc.' received');

        return $totalTTC;
    }

    private function calculateTotalHT($product)
    {
        $totalHT = $this->item->total_ttc * (100 / (100 + $product->vat->rate));

        if ($totalHT != $this->item->total_ttc)
            Log::warning('Item total HT should be equal to '.$totalHT.' whereas total HT '. $this->item->total_ht.' received');

        return $totalHT;
    }

    private function calculateTotalTVA()
    {
        $totalTVA = $this->item->total_ttc - $this->item->total_ht;

        if ($totalTVA != $this->item->total_tva)
            Log::warning('Item total TVA should be equal to '.$totalTVA.' whereas total TVA '. $this->item->total_tva.' received');

        return $totalTVA;
    }
    
    private function fillOtherProperties($product){
        $this->item->discount_ERP_group_code  = $product->discount_ERP_group_code;
        $this->item->discount_rate = $product->discount_rate;
        $this->item->product_id = $product->id;
        $this->item->saisir_longueur = $product->saisir_longueur;
        $this->item->saisir_largeur = $product->saisir_largeur;
        $this->item->saisir_hauteur = $product->saisir_hauteur;
        $this->item->saisir_dim_supp_1 = $product->saisir_dim_supp_1;
        $this->item->label_dim_supp_1 = $product->label_dim_supp_1;
        $this->item->saisir_dim_supp_2 = $product->saisir_dim_supp_2;
        $this->item->label_dim_supp_2 = $product->label_dim_supp_2;
        $this->item->saisir_dim_supp_3 = $product->saisir_dim_supp_3;
        $this->item->label_dim_supp_3 = $product->label_dim_supp_3;
        $this->item->saisir_dim_supp_4 = $product->saisir_dim_supp_4;
        $this->item->label_dim_supp_4 = $product->label_dim_supp_4;
        $this->item->saisir_dim_supp_5 = $product->saisir_dim_supp_5;
        $this->item->label_dim_supp_5 = $product->label_dim_supp_5;
        $this->item->saisir_info_supp_1 = $product->saisir_info_supp_1;
        $this->item->label_info_supp_1 = $product->label_info_supp_1;
        $this->item->saisir_info_supp_2 = $product->saisir_info_supp_2;
        $this->item->label_info_supp_2 = $product->label_info_supp_2;
        $this->item->product_name = $product->name;
        $this->item->product_ERP_code = $product->ERP_code;
        $this->item->product_non_standard = $product->non_standard;
        $this->item->product_unit_id = $product->unit_id;
        $this->item->product_type_id = $product->type_id;
        $this->item->product_length = $product->length;
        $this->item->product_width = $product->width;
        $this->item->product_height = $product->high;
        $this->item->product_price_ttc = $product->price_ttc;
        $this->item->product_vat = $product->vat->rate;
    }

    private function fillDimensionProperties($product,$inputItem) {
        if ($product->saisir_longueur == 1 && isset($inputItem['length']))
            $this->item->length = (float) $inputItem['length'];
        if ($product->saisir_largeur == 1 && isset($inputItem['width']))
            $this->item->width = (float) $inputItem['width'];
        if ($product->saisir_hauteur == 1 && isset($inputItem['high']))
            $this->item->high = (float) $inputItem['high'];
        if ($product->saisir_dim_supp_1 == 1 && isset($inputItem['dim_supp_1']))
            $this->item->dim_supp_1 = (float) $inputItem['dim_supp_1'];
        if ($product->saisir_dim_supp_2 == 1 && isset($inputItem['dim_supp_2']))
            $this->item->dim_supp_2 = (float) $inputItem['dim_supp_2'];
        if ($product->saisir_dim_supp_3 == 1 && isset($inputItem['dim_supp_3']))
            $this->item->dim_supp_3 = (float) $inputItem['dim_supp_3'];
        if ($product->saisir_dim_supp_4 == 1 && isset($inputItem['dim_supp_4']))
            $this->item->dim_supp_4 = (float) $inputItem['dim_supp_4'];
        if ($product->saisir_dim_supp_5 == 1 && isset($inputItem['dim_supp_5']))
            $this->item->dim_supp_5 = (float) $inputItem['dim_supp_5'];
        if ($product->saisir_info_supp_1 == 1 && isset($inputItem['info_supp_1']))
            $this->item->info_supp_1 = $inputItem['info_supp_1'];
        if ($product->saisir_info_supp_2 == 1 && isset($inputItem['info_supp_2']))
            $this->item->info_supp_2 = $inputItem['info_supp_2'];
    }

    private function fillQuantity($inputItem) {
        $this->item->quantity = 1;
        if (isset($inputItem['quantity']))
            $this->item->quantity = (float) $inputItem['quantity'];
    }

    private function fillProduct($inputItem) {
        $this->item->product_id = $inputItem['product_id'];
    }

    private function fillVariant($inputItem) {
        if (isset($inputItem['variant_id'])) {
            $this->item->variant_id = $inputItem['variant_id'];
            $variant = Variant::findOrFail($this->item->variant_id);
            $this->item->variant_ERP_code = $variant->ERP_code;
        }
    }
}
