<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Individuals\Group;
use Log;

class GroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        return Group::get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $group = Group::with('category', 'products', 'pictures')->findOrFail($id);

        return $group;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function search($key)
    {
        //
        Log::debug("Search Key before: '". $key."'");
        $key = str_replace("+"," ",$key);
        Log::debug("Search Key after: '". $key."'");

        return Group::with('category', 'products')
                    ->whereHas('products', function ($query) use($key) {
                        $query->where('name', 'like', '%'.$key.'%');
                    })->get();
    }
}
