<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Individual;
use App\User;
use App\Http\Utils\MyLog;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Jrean\UserVerification\Facades\UserVerification;
use Log;
use Validator;


class IndividualController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $warning = null;
        $status = null;

        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => array('required','min:6','max:20','regex:/^[(\d\p{L} !@#$%^&*()_+\-=\[\]{};\':"\\|,.<>\/?)|]+$/u'),
            'first_name' => 'required|min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'last_name' => 'required|min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'mobile' => 'required|digits:10',
            'landphone' => 'digits:10',
            'adress' => 'required|min:3|max:200|regex:/^[(\d\p{L} \-\',.)]+$/u',
            'zip_code' => 'digits:5',
            'town_id' => 'required|integer',
            'civility_id' => 'required|integer'
        ]);

        if ($validator->fails()){
            $status = 400;
            $warning = 'validation_error';
            $messages = $validator->errors()->all();
            MyLog::Warning($status, $warning, null, $messages);
            return response()->json(['error' => $warning, 'messages' => $messages], $status);
        }

        $inputs = $request->all();

        $user_stored = User::where('email', $request->email)->first();
        if ($user_stored != null)
            $warning = 'user_already_exist_email';

        /*
        $individual_stored = Individual::where('first_name', $request->first_name)->where('last_name', $request->last_name)->first();
        if ($individual_stored != null)
            $warning = 'user_already_exist_names';

        $individual_stored = Individual::where('mobile', $request->mobile)->first();
        if ($individual_stored != null)
            $warning = 'user_already_exist_mobile';
        */

        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        DB::transaction(function () use ($inputs, $request) {
            // Authentification storage
            $user = new User();
            if (isset($inputs['email']))
                $user->email = $inputs['email'];
            if (isset($inputs['password']))
                $user->password = Hash::make($request->password);
            $user->name = '';
            $user->is_individual = 1;
            $user->save();

            // Individual information storage
            $individual = new Individual();
            $individual->client_id = 1;
            foreach ($inputs as $key => $value) {
                if ($key != 'email' && $key != 'password')
                    $individual[$key] = $value;
            }
            $user->individual()->save($individual);
            // Send mail
            //Mail::to($user->email)->send(new IndividualCreated($individual));
            //
            UserVerification::generate($user);
            UserVerification::send($user, 'Vérification de l\'e-mail');
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
        $user = Auth::user();
        $individual = $user->individual;
        $individual->user;
        $individual->client;
        $individual->civility;
        $individual->town;
        return $individual;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $warning = null;
        $status = null;

        $validator = Validator::make($request->all(), [
            'first_name' => 'min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'last_name' => 'min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'mobile' => 'digits:10',
            'landphone' => 'digits:10',
            'adress' => 'min:3|max:200|regex:/^[(\d\p{L} \-\',.)]+$/u',
            'zip_code' => 'digits:5',
            'town_id' => 'integer',
            'civility_id' => 'integer'
        ]);

        if ($validator->fails()){
            $status = 400;
            $warning = 'validation_error';
            $messages = $validator->errors()->all();
            MyLog::Warning($status, $warning, null, $messages);
            return response()->json(['error' => $warning, 'messages' => $messages], $status);
        }

        $user = Auth::user();
        $individual = $user->individual;

        /*
        if (Input::has('first_name'))
            $individual->first_name = $request->first_name;
        if (Input::has('last_name'))
            $individual->last_name = $request->last_name;
        if (Input::has('mobile'))
            $individual->mobile = $request->mobile;

        $individuals_count = Individual::where('first_name', $individual->first_name)->where('last_name', $individual->last_name)->count();
        if ($individuals_count > 1)
            $warning = 'user_already_exist_names';
        else {
            $individuals_count = Individual::where('mobile', $individual->mobile)->count();
            if ($individuals_count > 1)
                $warning = 'user_already_exist_mobile';
        }

        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($request, $status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }
        */

        $inputs = $request->all();
        DB::transaction(function () use ($inputs, $individual, $user) {
            // Individual information storage
            foreach ($inputs as $key => $value) {
                if ($key != 'email' && $key != 'password')
                    $individual[$key] = $value;
                if ($key == 'password') {
                    $user[$key] = Hash::make($value);
                    $user->save();
                }
            }
            $individual->save();
        });
    }
}
