<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;


class AccessController extends Controller
{
    /**
     * Check the permission on Admin resources.
     *
     * @return \Illuminate\Http\Response
     */
    public function check()
    {
        //
        $user = Auth::user();
        $reseller = $user->reseller;
        $company = $reseller->company;
        $client = $company->client;

        $warning = null;
        $message = null;

        if ($reseller->deactivated || $company->deactivated || $client->deactivated) {
            $status = 401;
            $warning = 'deactivated_user';
            $message = Lang::get('messages.'.$warning);
        }
        else
            $status = 200;

        if ($warning != null)
            return response()->json(['error' => $warning, 'message' => $message], $status);
        else
            return;
    }
}
