<?php
/**
 * Created by PhpStorm.
 * User: KBM-Adil_Zaid
 * Date: 11/04/2017
 * Time: 14:38
 */

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Api\Users\V1_0\WelcomePictureController;
use App\Http\Controllers\Api\V1_0\StatusController;
use App\Models\Constant;
use App\Models\Users\Resellers\Category;
use App\Models\Users\Resellers\CommandType;
use App\Models\Users\Resellers\DeliveryAddress;
use App\Models\Users\Resellers\Message;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Log;
use App\Http\Utils\Miscellaneous;

class DataController
{
    protected $category;

    public function __construct(Category $category){
        $this->category = $category;
    }

    /**
     * Display all slider, 4 catalogs, messages & delivery adresses.
     *
     * @return \Illuminate\Http\Response
     */
    public function allData($version)
    {
        //
        (new AccessController())->check();

        if ($version == $this->version())
            return;

        $user = Auth::user();
        $client_id = $user->reseller->company->client->id;
        $this->category->client_id = $client_id;

        $category = new Category();
        $catalogController = new CatalogController($category);

        $standardProductsCategories = $catalogController->getStandardProductsCategories($client_id);
        $nonStandardProductsCategories = $catalogController->getNonStandardProductsCategories($client_id);
        $specificProductsCategories = $catalogController->getSpecificProductsCategories($client_id);
        $favouriteProductsCategories = $catalogController->getFavouriteProductsCategories($client_id);
        $mesages = $catalogController->getMessages($client_id);
        $deliveryAddresses = $catalogController->getDeliveryAddresses($client_id);
        $welcomePictures = WelcomePictureController::getWelcomePictures();
        $profile = (new ResellerController())->show();
        $statuses = (new StatusController())->index();
        $commandTypes = $this->getCommandTypes();

        return response()->json(['version' => $this->version(),
                                 'data' => ['profile' => $profile,
                                            'statics' => ['statuses' => $statuses,
                                                          'commandTypes' => $commandTypes,
                                                          'welcomePictures' => $welcomePictures],
                                            'catalogs' => ['favouriteProductsCategories' => $favouriteProductsCategories,
                                                                'standardProductsCategories' => $standardProductsCategories,
                                                            'nonStandardProductsCategories' => $nonStandardProductsCategories,
                                                            'specificProductsCategories' => $specificProductsCategories],
                                            'messages' => $mesages,
                                            'deliveryAddresses' => $deliveryAddresses
                                            ]
                                 ],
                                200);
    }
    
    private function getCommandTypes() {
        $commandTypes = CommandType::where('deactivated', 0)->orderBy('order', 'ASC')->get();
        return $commandTypes;
    }

    /**
     * Display the catalog version.
     *
     * @return \Illuminate\Http\Response
     */
    public function version()
    {
        //
        return Miscellaneous::getVersion();
    }
}
