<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\MyLog;
use App\Models\Users\Resellers\Favourite;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;
use Lang;
use App\Http\Utils\Miscellaneous;


class FavouriteController extends Controller
{
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
        $client_id = $user->reseller->company->client->id;

        return Favourite::where('client_id', $client_id)->where('deactivated', 0)->get();
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $user = Auth::user();
        $client_id = $user->reseller->company->client->id;
        $warning = null;

        $favourite = Favourite::where('client_id', $client_id)->where('product_id', $request->product_id)->first();
        if ($favourite != null)
            $warning = 'favourite_already_exists_name';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        DB::transaction(function () use ($request, $client_id) {
            $favourite = new Favourite();
            $favourite->client_id = $client_id;
            $favourite->product_id = $request->product_id;
            $favourite->save();

            Miscellaneous::incrementVersion();
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $favourite = Favourite::findOrFail($id);

        return $favourite;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
        $favourite = Favourite::findOrFail($id);

        $favourite->delete();
    }

}
