<?php

namespace App\Jobs\Mails\Resellers;

use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Log;

class CommandCreated implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $email;
    protected $command;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($email, $command)
    {
        //
        $this->email = $email;
        $this->command = $command;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(Mailer $mailer)
    {
        //
        $command = $this->command;
        $mailer->send('emails.resellers.commands.created', compact('command'), function ($message) {
            //
            if ($this->command->type_id == 1)
                $message->to($this->email)
                    ->subject('Commande N° ' . $this->command->number);
            else if ($this->command->type_id == 2)
                $message->to($this->email)
                    ->subject('Retour N° ' . $this->command->number);
        });
    }
}
