<?php

namespace App\Mail\Individuals;

use App\Models\Users\Command;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CommandCreated extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The command instance.
     *
     * @var command
     */
    public $command;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Command $command)
    {
        //
        $this->command = $command;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->command = $this->command->fresh();
        return $this->subject('Commande N° '.$this->command->number)
            ->view('emails.individuals.commands.created');
    }
}
