<?php

namespace App\Mail\Individuals;

use App\Models\Users\Individual;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Registered extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The individual instance.
     *
     * @var individual
     */
    public $individual;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Individual $individual)
    {
        //
        $this->individual = $individual;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Notification d'enregistrement")
            ->view('emails.individuals.registered');
    }
}
