<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;
use Log;

class Delivery extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'delivery_address_id', 'delivery_address_code', 'company_name', 'first_name', 'last_name', 'zip_code', 'command', 'channel'];


    /**
     * The attributes that should be appended to arrays.
     *
     * @var array
     */
    protected $appends = ['address_code', 'full_name', 'email'];

    /**
     * Get the calculated reseller's address code.
     */
    public function getAddressCodeAttribute() {
        return $this->delivery_address_code;
    }

    /**
     * Get the calculated reseller's name.
     */
    public function getFullNameAttribute() {
        return $this->last_name . ' ' . $this->first_name;
    }

    public function command(){
        return $this->hasOne('App\Models\ERP\Command');
    }

    /**
     * Get the the calculated email.
     */
    public function getEmailAttribute() {
        $command = $this->command;
        $channel = $command->channel;

        Log::debug('Command number: '.$command->number);

        if ($channel->id == 1 ) {
            if ($command->individual != null) {
                if ($command->individual->user != null) {
                    return $command->individual->user->email;
                }
            }
        }
        else if  ($channel->id == 2 ) {
            if ($command->reseller != null) {
                if ($command->reseller->company != null) {
                    return $command->reseller->company->email;
                }
            }
        }

        return null;
    }

    /**
     * Get the calculated individual's adress.
     */
    public function getFullAdressAttribute() {
        $adress = '';
        if ($this->adress != null)
            $adress = $this->adress;
        if ($this->adress_followup)
            $adress .= ', ' . $this->adress_followup;
        if ($this->town)
            $adress .= ', ' . $this->town;

        return $adress;
    }
}
