<?php

namespace App\Models\Users\Individuals;

use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'command_id', 'variant_id', 'client_id', 'total_ttc', 'total_ht', 'total_tva'];

    protected $appends = ['ttc_total', 'ht_total', 'tva_total'];

    function getTtcTotalAttribute() {
        return number_format($this->total_ttc, 2, ',', ' ');
    }

    function getHtTotalAttribute() {
        return number_format($this->total_ht, 2, ',', ' ');
    }

    function getTvaTotalAttribute() {
        return number_format($this->total_tva, 2, ',', ' ');
    }
}
