<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;

class Reseller extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'reseller_company_id', 'user_id'];

    /**
     * Get the user that this reseller belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the company that belongs to this reseller.
     */
    public function company()
    {
        return $this->belongsTo('App\Models\Users\ResellerCompany');
    }


    /**
     * Get the client that belongs to this reseller.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\Users\Client');
    }

}
