<?php

namespace App\Models\Users\Resellers;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'products';

    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual', 'group_id', 'unit_id', 'type_id', 'vat_id'];

    //protected $appends = ['dimensions'];

    /**
     * Get the Type Unit that owns the Product.
     */
    public function unit()
    {
        return $this->belongsTo('App\Models\Users\Unit');
    }

    /**
     * Get the Type Type that owns the Product.
     */
    public function type()
    {
        return $this->belongsTo('App\Models\Type');
    }

    /**
     * Get the Type Vat that owns the Product.
     */
    public function vat()
    {
        return $this->belongsTo('App\Models\Users\Vat');
    }

    /**
     * Get the Product Group that product belongs to.
     */
    public function group()
    {
        return $this->belongsTo('App\Models\Users\Resellers\Group');
    }

    /**
     * The Variants associated to this Product.
     */
    public function variants()
    {
        return $this->belongsToMany('App\Models\Users\Variant')->where('deactivated', 0);
    }

    /**
     * The Discount associated to this Product.
     */
    public function discount()
    {
        return $this->belongsTo('App\Models\Users\Discount');
    }


    /**
     * The Dimensions to display for this Product.
     */
    /*
    public function getDimensionsAttribute()
    {
        $dimensions = "";

        if (($this->length == null || $this->length == 0)  &&
            ($this->width == null ||$this->width == 0) &&
            ($this->high == null || $this->high == 0))
            return $this->name;

        if ($this->saisir_longueur == 0 && $this->length != null && $this->length != 0)
            $dimensions = ($this->length * 100);
        if ($this->saisir_largeur  == 0 && $this->width != null && $this->width != 0) {
            if ($dimensions == "")
                $dimensions = $this->width * 100;
            else
                $dimensions .= ' x ' . ($this->width * 100);
        }
        if ($this->saisir_hauteur  == 0 && $this->high != null && $this->high != 0) {
            if ($dimensions == "")
                $dimensions = $this->high * 100;
            else
                $dimensions .= ' x ' . ($this->high * 100);
        }


        if ($this->type != null)
            $dimensions .= ' - ' . $this->type->name;
        
        return $dimensions;
    }
    */
}
