<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [ 'name', 'email', 'password'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'name', 'password', 'remember_token', 'verified', 'verification_token', 'is_admin', 'is_individual', 'is_reseller', 'is_ERP'];

    /**
     * The attributes that should be casted.
     *
     * @var array
     */
    protected $casts = [
        'is_admin' => 'boolean',
    ];

    /**
     * Get the Individual that belongs to that user.
     */
    public function individual()
    {
        return $this->hasOne('App\Models\Users\Individual');
    }

    /**
     * Get the Reseller that belongs to that user.
     */
    public function reseller()
    {
        return $this->hasOne('App\Models\Users\Reseller');
    }

    /**
     * Check if the user is Admin.
     */
    public function isAdmin()
    {
        return $this->is_admin;
    }

    /**
     * Check if the user is ERP.
     */
    public function isERP()
    {
        return $this->is_ERP;
    }

    /**
     * Check if the user is a user customer.
     */
    public function isUser()
    {
        return $this->is_individual || $this->is_reseller;
    }

    /**
     * Check if the user is Individual.
     */
    public function isIndividual()
    {
        return $this->is_individual;
    }

    /**
     * Check if the user is Individual.
     */
    public function isReseller()
    {
        return $this->is_reseller;
    }


    /**
     * Check if the user is Verified.
     */
    public function isVerified()
    {
        return $this->verified;
    }
}
