<!DOCTYPE html>
<html lang="fr">
    <head>
        @if ($command->type_id == 1)
            <title>Confirmation de la commande</title>
        @elseif ($command->type_id == 2)
            <title>Confirmation du retour</title>
        @endif
        <style>
            .sumuptable {
                border: 1px solid black;
                border-collapse: collapse;
                margin: 0 auto;
                width: 60%;
                font-size: 21px;
            }
            .itemstable {
                border: 1px solid black;
                border-collapse: collapse;
                width: 100%;
                font-size: 18px;
            }
            .deliverytable {
                border: 1px solid black;
                border-collapse: collapse;
                margin-right: 0px;
                width: 40%;
                font-size: 20px;
            }
            .totaltable {
                border: 1px solid black;
                border-collapse: collapse;
                margin-right: 0px;
                margin-left: auto;
                width: 20%;
                font-size: 21px;
            }
            th {
                border: 1px solid black;
                border-collapse: collapse;
            }
            th {
                border: 1px solid black;
                border-collapse: collapse;
            }
            .td_sumup {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: center;
            }
            .td_number {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: right;
            }
            .td_name {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: left;
                min-width: 250px;
            }
            .td_string {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: center;
            }
            .td_label {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: left;
            }
            .td_total_ttc {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: right;
                min-width: 100px;
            }
            .td_delivery {
                border: 1px solid black;
                border-collapse: collapse;
                text-align: center;
            }
            div {
                left: 0;
                top: 0;
                text-align: center;
                font-size: 22px;
                font-weight: bold;
            }
            .container {
                width:1400px;
                margin: 0 auto;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <br>
            <br>
            @if ($command->type_id == 1)
                <div>Votre commande N° {{$command->number}}</div>
            @elseif ($command->type_id == 2)
                <div>Votre retour N° {{$command->number}}</div>
            @endif
            <br>
            <br>
            <br>
            <table class="sumuptable">
                <tr>
                    <th>Numéro</th>
                    <th>Date création</th>
                    <th>Statut</th>
                </tr>
                <tr>
                    <td class="td_sumup">{{$command->number}}</td>
                    <td class="td_sumup">{{$command->created_at->format('d-m-Y')}}
                    <td class="td_sumup">{{$command->status->name}}</td>
                </tr>
            </table>
            <br>
            <br>
            <table class="itemstable">
                <tr>
                    <th>Produit</th>
                    <th>Variante</th>
                    <th>Prix unitaire TTC</th>
                    <th>Longueur</th>
                    <th>Largeur</th>
                    <th>Hauteur</th>
                    <th>Label dim supp 1</th>
                    <th>Dim supp 1</th>
                    <th>Label dim supp 2</th>
                    <th>Dim supp 2</th>
                    <th>Label dim supp 3</th>
                    <th>Dim supp 3</th>
                    <th>Label dim supp 4</th>
                    <th>Dim supp 4</th>
                    <th>Label dim supp 5</th>
                    <th>Dim supp 5</th>
                    <th>Label info Supp 1</th>
                    <th>Info supp 1</th>
                    <th>Label info Supp 2</th>
                    <th>Info supp 2</th>
                    <th>Quantité</th>
                    <th>Remise %</th>
                    <th>Total TTC</th>
                </tr>
                @foreach ($command->items as $item)
                    <tr>
                        <td class="td_name">{{$item->product_name}}</td>
                        <td class="td_string">{{$item->variant_ERP_code}}</td>
                        <td class="td_number">{{number_format($item->unitary_ttc, 2, ',', ' ')}}</td>
                        @if ($item->saisir_longueur==1 && $item->length != null)
                            <td class="td_number">{{number_format($item->length, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_largeur==1 && $item->width != null)
                            <td class="td_number">{{number_format($item->width, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_hauteur==1 && $item->high != null)
                            <td class="td_number">{{number_format($item->high, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_dim_supp_1==1 && $item->dim_supp_1 != null)
                            <td class="td_label">{{$item->label_dim_supp_1}}</td>
                            <td class="td_number">{{number_format($item->dim_supp_1, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_dim_supp_2==1 && $item->dim_supp_2 != null)
                            <td class="td_label">{{$item->label_dim_supp_2}}</td>
                            <td class="td_number">{{number_format($item->dim_supp_2, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_dim_supp_3==1 && $item->dim_supp_3 != null)
                            <td class="td_label">{{$item->label_dim_supp_3}}</td>
                            <td class="td_number">{{number_format($item->dim_supp_3, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_dim_supp_4==1 && $item->dim_supp_4 != null)
                            <td class="td_label">{{$item->label_dim_supp_4}}</td>
                            <td class="td_number">{{number_format($item->dim_supp_4, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_dim_supp_5==1 && $item->dim_supp_5 != null)
                            <td class="td_label">{{$item->label_dim_supp_5}}</td>
                            <td class="td_number">{{number_format($item->dim_supp_5, 2, ',', ' ')}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_info_supp_1==1 && $item->info_supp_1 != null)
                            <td class="td_label">{{$item->label_info_supp_1}}</td>
                            <td class="td_number">{{$item->info_supp_1}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        @if ($item->saisir_info_supp_2==1 && $item->info_supp_2 != null)
                            <td class="td_label">{{$item->label_info_supp_2}}</td>
                            <td class="td_number">{{$item->info_supp_2}}</td>
                        @else
                            <td class="td_string">-</td>
                            <td class="td_string">-</td>
                        @endif
                        <td class="td_number">{{$item->quantity}}</td>
                        @if ($item->discount_rate != null)
                            <td class="td_number">{{$item->discount_rate}}</td>
                        @else
                            <td class="td_string">-</td>
                        @endif
                        <td class="td_total_ttc">{{$item->ttc_total}}</td>
                    </tr>
                @endforeach
            </table>
            <br>
            <table  class="totaltable">
                <tr class>
                    <th>Prix Total TTC</th>
                </tr>
                <tr>
                    <td class="td_number">{{$command->ttc_total}}</td>
                </tr>
            </table>
            <br>
            <table  class="deliverytable">
                <tr>
                    @if ($command->type_id == 2)
                        <th>Adresse de retour</th>
                    @else
                        <th>Adresse de livraison</th>
                    @endif
                </tr>
                <tr>
                    @if ($command->delivery != null)
                        <td class="td_delivery">@if ($command->delivery->last_name && $command->delivery->last_name){{$command->delivery->last_name}} {{$command->delivery->first_name}}<br> @endif @if($command->delivery->adress){{$command->delivery->adress}}@endif @if($command->delivery->adress_followup!=null){{$command->delivery->adress_followup}}<br>@endif{{$command->delivery->town}}<br>{{$command->delivery->phone}}</td>
                    @else
                        <td class="td_delivery">&nbsp;</td>
                    @endif
                </tr>
            </table>
        </div>
    </body>
</html>
