/**
 * @author majid
 * created on 13.01.2017
 */
(function () {
  'use strict';

  angular.module('BlurAdmin.pages.catalogue.categories', [])
      .config(routeConfig);

  /** @ngInject */
  function routeConfig($stateProvider) {
    $stateProvider
        .state('catalogue.categories', {
          url: '/categories',
          templateUrl: 'app/pages/catalogue/categories/categories.html',
          title: 'Familles',
          sidebarMeta: {
            icon: 'ion-grid',
            order: 100,
          },
            controller: function($scope, $http, $stateParams, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');
               // console.log('access '+$scope.checkAccessUser())
                $scope.isShowLoader = true;
                $('#Loaderdiv').show();
                $('#msgTop').hide();
                $('#msgError').hide();
                $('#divBody').hide();
                $scope.categories          = [];
                $scope.totalCategories     = 0;
                $scope.categoriesPerPage   = 25;
                $scope.pageChanged = function(newPage) {
                    getCategories(newPage);
                };
                function getCategories (pageNumber) {
                    var url = $scope.url+"categories?pagination_per_page=25&page="+pageNumber;
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        if(response.status == 200) {
                            $('#divBody').show();
                            $scope.categories = response.data.data;
                            $scope.totalCategories = response.data.total;

                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                            $('#divBody').hide();
                        }
                    }, function errorCallback(response) {
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#Loaderdiv').hide();
                        $('#msgError').show();
                        $('#divBody').hide();
                    });
                };
                getCategories($scope.pagination.currentFamille);

                // deactivate category
                $scope.deactivateCategory = function (id, activated) {
                    var url = $scope.url+"categories/"+id;
                    $('#msgTop').hide();
                    $('#msgError').hide();
                    $scope.datas = {
                        deactivated          : activated
                    };
                    $http({
                        method: 'PUT',
                        url: url,
                        params :  $scope.datas,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {

                        if(response.status == 200) {
                            //showLoader();
                            $('#msgTop').show();
                            getCategories($scope.pagination.current);
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#msgError').show();
                    });
                }

                // Hide message
                $scope.hideMsg = function () {
                    $('#msgTop').hide();
                }

            }
        }).state('consultationCategory', {
        url: '/consultationCategory',
        params: {id : null},
        templateUrl: 'app/pages/catalogue/categories/consultationCategory/consultationCategory.html',
        controller: function ($scope, $stateParams, $http, $state) {
            if(!$scope.isLogged())
                window.location.replace('/#/login');
            $scope.categorieId =  $stateParams.id;
            if($stateParams.id != null)
                $scope.putCoockie('parmsID', $stateParams.id);
            $('#msgError').hide();
            $('#divBody').hide();

            var url = $scope.url+"categories/"+$scope.getCoockie('parmsID');

            $http({
                method: 'GET',
                url: url,
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "Authorization" : $scope.userSession()
                }
            }).then(function successCallback(response) {
                if(response.status == 200) {
                    $('#msgError').hide();
                    $('#divBody').show();
                    $scope.detailCategory = response.data;
                    $scope.descriptionMdl = $scope.detailCategory.description;
                    $scope.nameMdl        = $scope.detailCategory.name ;
                } else {
                    $scope.error_response = $scope.getErrorMessage(response);
                    $('#msgError').show();
                    $('#divBody').hide();
                }


            }, function errorCallback(response) {
                $scope.error_response = $scope.getErrorMessage(response);
                $('#msgError').show();
                $('#divBody').hide();
            });
        }
    }).state('updateCategory', {
        url: '/updateCategory',
        params: {id : null},
        templateUrl: 'app/pages/catalogue/categories/updateCategory/updateCategory.html',
        controller: function ($scope, $stateParams, $http, $state) {
            $('#msgBottom').hide();
            $('#LoaderdivBottom').hide();
            $('#msgError').hide();
            $('#divBody').hide();
            if($stateParams.id != null)
                $scope.putCoockie('parmsID', $stateParams.id);
            if (!$scope.isLogged()){
                window.location.replace('/#/login');
            } else {
            $scope.categorieId =  $stateParams.id;
            var url = $scope.url+"categories/"+$scope.getCoockie('parmsID');
            $http({
                method: 'GET',
                url: url,
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "Authorization" : $scope.userSession()
                }
            }).then(function successCallback(response) {
                if(response.status == 200) {
                    $scope.detailCategory = response.data;

                    $('#msgError').hide();
                    $('#divBody').show();
                } else {
                    $scope.error_response = $scope.getErrorMessage(response);
                    $('#msgError').show();
                    $('#divBody').hide();
                }

            }, function errorCallback(response) {
                $scope.error_response = $scope.getErrorMessage(response);
                $('#msgError').show();
                $('#divBody').hide();
            });
            }

            // update category
            $scope.updateCategory = function () {

                $scope.category_data = {
                    deactivated          : $scope.detailCategory.deactivated,
                    visible_individual   : $scope.detailCategory.visible_individual,
                    name                 : $scope.detailCategory.name,
                    description          :  $scope.detailCategory.description
                };
                putCategory($scope.category_data);
            }
            function putCategory(datas) {
                $('#msgBottom').hide();
                $('#LoaderdivBottom').show();
                var url = $scope.url+"categories/"+$scope.getCoockie('parmsID');
                $http({
                    method: 'PUT',
                    url: url,
                    data :  JSON.stringify(datas),
                    headers: {
                        "Content-Type": "application/json",
                        "Authorization" : $scope.userSession()
                    }
                }).then(function successCallback(response) {
                    if(response.status == 200) {
                        //$scope.detailCategory = response.data;
                        window.location.replace('/#/catalogue/categories');
                    } else
                        $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').hide();
                }, function errorCallback(response) {
                    $('#msgBottom').show();
                    $('#LoaderdivBottom').hide();
                    $scope.error_update_category = $scope.getErrorMessage(response);
                });
            }

            $scope.checkDeactivate = function() {
                if ($scope.detailCategory.deactivated == 0)
                    $scope.detailCategory.deactivated = 1;
                else
                    $scope.detailCategory.deactivated = 0;
            }
            $scope.checkVisible = function() {
                if ($scope.detailCategory.visible_individual == 0)
                    $scope.detailCategory.visible_individual = 1;
                else
                    $scope.detailCategory.visible_individual = 0;
            }
        }
    }).state('addCategory', {
        url: '/addCategory',
        templateUrl: 'app/pages/catalogue/categories/addCategory/addCategory.html',
        controller: function ($scope, $stateParams, $http, $state) {
            if(!$scope.isLogged())
                window.location.replace('/#/login');
            $('#msgTop').hide();
            $('#msgBottom').hide();
            $('#LoaderdivBottom').hide();

            $scope.detailCategory = {deactivated: 0,
                                     visible_individual : 0,
                                     name: null,
                                     description: null};

            var url = $scope.url+"categories";
            $scope.add = function () {
                $('#msgBottom').hide();
                $('#LoaderdivBottom').show();
                $scope.category_data = {
                    deactivated          : $scope.detailCategory.deactivated,
                    visible_individual   : $scope.detailCategory.visible_individual,
                    name                 : $scope.detailCategory.name,
                    description          : $scope.detailCategory.description
                };
                $http({
                    method: 'POST',
                    url: url,
                    data :  JSON.stringify($scope.category_data),
                    headers: {
                        "Content-Type": "application/json",
                        "Authorization" : $scope.userSession()
                    }
                }).then(function successCallback(response) {
                    if(response.status == 200){
                        $scope.responseAdd = response.data;
                        window.location.replace('/#/catalogue/categories');
                    } else {
                        $scope.error_add_category = $scope.getErrorMessage(response);
                        $('#msgTop').show();
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                    }

                }, function errorCallback(response) {
                    $('#msgTop').show();
                    $('#msgBottom').show();
                    $('#LoaderdivBottom').hide();
                    $scope.error_add_category = $scope.getErrorMessage(response);

                });
            }

            // Hide message
            $scope.hideMsg = function () {
                $('#msgTop').hide();
            }

            $scope.checkDeactivate = function() {
                if ($scope.detailCategory.deactivated == 0)
                    $scope.detailCategory.deactivated = 1;
                else
                    $scope.detailCategory.deactivated = 0;
            }
            $scope.checkVisible = function() {
                if ($scope.detailCategory.visible_individual == 0)
                    $scope.detailCategory.visible_individual = 1;
                else
                    $scope.detailCategory.visible_individual = 0;
            }
        }
    });
  }

})();
