/**
 * Created by majid on 14/01/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.catalogue.remises', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('catalogue.remises', {
                url: '/remises',
                templateUrl: 'app/pages/catalogue/remises/remises.html',
                title: 'Groupe Remises',
                sidebarMeta: {
                    icon: 'ion-android-home',
                    order: 500,
                },
                controller: function($scope, $http, $stateParams, $state) {
                    if (!$scope.isLogged())
                        window.location.replace('/#/login');

                    $('#Loaderdiv').show();
                    $('#divTable').hide();
                    $('#msgTop').hide();
                    $('#msgError').hide();

                    $scope.remises          = [];
                    $scope.totalRemises     = 0;
                    $scope.remisesPerPage   = 25;


                    $scope.pageChanged = function(newPage) {
                        getRemises(newPage);
                    };

                    function getRemises(pageNumber) {
                        var url = $scope.url+"discounts?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200) {
                                $scope.remises = response.data.data;
                                $scope.totalRemises = response.data.total;
                                $('#msgError').hide();
                                $('#divTable').show();
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                                $('#divTable').hide();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                            $('#divTable').hide();
                            $('#Loaderdiv').hide();


                        });
                    }
                    getRemises($scope.pagination.currentRemise);

                    $scope.deactivateRemise = function (id, val) {
                        $('#msgError').hide();
                        var url = $scope.url+"discounts/"+id;
                        $scope.remise_data = {
                            deactivated                : val
                        };
                        $http({
                            method: 'PUT',
                            url: url,
                            params : $scope.remise_data,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200){
                                $('#msgTop').show();
                                getRemises($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        });
                    }

                }
            }).state('addRemise', {
                url: '/addRemise',
                params: {id : null},
                templateUrl    : 'app/pages/catalogue/remises/addRemise/addRemise.html',
                reloadOnSearch : true,

                controller: function ($scope, $http, $stateParams, $state) {
                    if (!$scope.isLogged())
                        window.location.replace('/#/login');
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').hide();

                    $scope.addRemise = function () {
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').show();

                        var url = $scope.url+"discounts";
                        $scope.remise_data = {
                            deactivated                : $scope.booleanToInteger($scope.deactivateMdl),
                            ERP_group_code             : $scope.nameMdl,
                            description                : $scope.descriptionMdl
                        };
                        $http({
                            method: 'POST',
                            url: url,
                            data :  $.param($scope.remise_data),
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#msgBottom').hide();
                            $('#LoaderdivBottom').hide();
                            if(response.status == 200)
                                window.location.replace('/#/catalogue/remises');
                            else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {
                            $('#msgBottom').show();
                            $('#LoaderdivBottom').hide();
                            $scope.error_add_remise = $scope.getErrorMessage(response);
                        });
                    }

                    $scope.checkName = function(val) {
                        $scope.nameMdl = val ;
                    }
                    $scope.checkDescription = function(val) {
                        $scope.descriptionMdl = val ;
                    }
                    $scope.checkDeactivate = function(val) {
                        $scope.deactivateMdl = val ;
                    }

                }
            }).state('consultationRemise', {
                url: '/consultationRemise',
                params: {id : null},
                templateUrl    : 'app/pages/catalogue/remises/consultationRemise/consultationRemise.html',

                controller: function ($scope, $http, $stateParams, $state) {
                    if (!$scope.isLogged())
                        window.location.replace('/#/login');
                    if($stateParams.id != null)
                        $scope.putCoockie('parmsID', $stateParams.id);

                    $('#Loaderdiv').show();
                    $('#divTable').hide();
                    $('#msgError').hide();
                    function getVariantes() {
                        var url = $scope.url+"discounts/"+$scope.getCoockie('parmsID');
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            $('#msgError').hide();
                            if(response.status == 200) {
                                $scope.detailRemise = response.data;
                                $scope.descriptionMdl = $scope.detailRemise.description;
                            } else {
                                $('#divTable').hide();
                                $('#msgError').show();
                                $scope.error_response = $scope.getErrorMessage(response);
                            }
                        }, function errorCallback(response) {
                            $scope.isShowLoader = false;
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                            $scope.error_response = $scope.getErrorMessage(response);


                        });
                    }
                    getVariantes();

                }
            }).state('updateRemise', {
                url: '/updateRemise',
                params: {id : null},
                templateUrl    : 'app/pages/catalogue/remises/updateRemise/updateRemise.html',
                controller: function ($scope, $http, $stateParams, $state) {

                    if (!$scope.isLogged())
                        window.location.replace('/#/login');
                    if($stateParams.id != null)
                        $scope.putCoockie('parmsID', $stateParams.id);

                    $('#Loaderdiv').show();
                    $('#divTable').hide();
                    $('#msgError').hide();
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').hide();

                    function getRemises() {
                        var url = $scope.url+"discounts/"+$scope.getCoockie('parmsID');
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();

                            if(response.status == 200) {
                                $('#divTable').show();
                                $('#msgError').hide();
                                $scope.detailRemise = response.data;
                                $scope.deactivateMdl  = $scope.integerToBoolean($scope.detailRemise.deactivated);
                                $scope.nameMdl = $scope.detailRemise.ERP_group_code;
                                $scope.descriptionMdl = $scope.detailRemise.description;
                            } else {
                                $('#divTable').hide();
                                $('#msgError').show();
                                $scope.error_response = $scope.getErrorMessage(response);
                            }


                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                            $scope.error_response = $scope.getErrorMessage(response);
                        });
                    }
                    getRemises();

                    $scope.updateRemise = function () {
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').show();
                        var url = $scope.url+"discounts/"+$scope.getCoockie('parmsID');
                        $scope.remise_data = {
                            deactivated                : $scope.booleanToInteger($scope.deactivateMdl),
                            ERP_group_code             : $scope.nameMdl,
                            description                : $scope.descriptionMdl
                        };
                        $http({
                            method: 'PUT',
                            url: url,
                            data :  $.param($scope.remise_data),
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#msgBottom').hide();
                            $('#LoaderdivBottom').hide();
                            if(response.status == 200)
                                window.location.replace('/#/catalogue/remises');
                            else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {
                            $('#msgBottom').show();
                            $('#LoaderdivBottom').hide();
                            $scope.error_update_remise = $scope.getErrorMessage(response);
                        });
                    }

                    $scope.checkName = function(val) {
                        $scope.nameMdl = val ;
                    }
                    $scope.checkDescription = function(val) {
                        $scope.descriptionMdl = val ;
                    }
                    $scope.checkDeactivate = function(val) {
                        $scope.deactivateMdl = val ;
                    }

                }
        });
    }

})();