/**
 * Created by majid on 08/02/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.resetPassword', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('resetPassword', {
                url: '/resetPassword',
                templateUrl: 'app/pages/resetPassword/resetPassword.html',
                title: 'Password',
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace(' /#/login');

                    $('#Loaderdiv').hide();
                    $('#msgBottom').hide();

                    $scope.updatePassword = function(old_password, new_password, confirm_new_password) {

                        $('#Loaderdiv').show();
                        $('#msgBottom').hide();
                        $scope.responsePassword = '';

                        $scope.password_data = {
                            old_password        : old_password,
                            new_password        : new_password,
                            confirm_password    : confirm_new_password

                        };

                        var url   = $scope.url+"password";
                        $http({
                            method  : 'PUT',
                            url     : url,
                            data    : $scope.password_data,
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $scope.responsePassword = response.data;
                            // if response 200 OK
                            if(response.status == 200) {
                                window.location.replace('#/acceuil');
                            } else {
                                $scope.responsePassword = $scope.getErrorMessage(response);
                                $('#msgBottom').show();
                            }

                            $('#Loaderdiv').hide();

                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#msgBottom').show();
                            $scope.responsePassword = $scope.getErrorMessage(response);

                        });
                    }

                    // check models changes
                    $scope.checkOldPassword = function (val) {
                        $scope.oldPasswordMdl = val;
                    };
                    $scope.checkNewPassword = function (val) {
                        $scope.passworNewdMdl = val;
                    };
                    $scope.checkConfirmNewPassword = function (val) {
                        $scope.confirmNewPasswordMdl = val;
                    };

                }

            });
    }

})();