/**
 * Created by majid on 29/01/2017.
 */

(function () {
    'use strict';

    angular.module('BlurAdmin.pages.utilisateurs.clients', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('utilisateurs.clients', {
                url: '/clients',
                templateUrl: 'app/pages/utilisateurs/clients/clients.html',
                //title: 'Clients',
                sidebarMeta: {
                    icon: 'glyphicon-th-list',
                    order: 100,
                },
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $('#Loaderdiv').show();
                    $('#divTable').hide();
                    $('#msgTop').hide();
                    $('#msgError').hide();
                    $scope.clients          = [];
                    $scope.totalClients     = 0;
                    $scope.clientsPerPage   = 25;

                    $scope.pagination = {
                        current: 1
                    };
                    $scope.pageChanged = function(newPage) {
                        getClients(newPage);
                    };
                    function getClients(pageNumber) {
                        var url = $scope.url+"clients?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200) {
                                $scope.clients = response.data.data;
                                $scope.totalClients = response.data.total;
                                $('#divTable').show();
                                $('#msgError').hide();

                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }
                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                        });
                    }
                    $scope.deactivateClient = function (id, val) {
                        $('#msgError').hide();
                        var client_data = {
                            deactivated  : val
                        };
                        var url = $scope.url+"clients/"+id;
                        $http({
                            method  : 'PUT',
                            url     : url,
                            params  :  client_data,
                            headers : {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200){
                                $('#msgTop').show();
                                getClients($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        });
                    }

                    getClients(1);

                }

            }).state('consultationClient', {
            url: '/consultationClient',
            params: {id : null},
            templateUrl    : 'app/pages/utilisateurs/clients/consultationClient/consultationClient.html',
            title: 'Consultation Client',
            controller: function ($scope, $http, $stateParams, $state) {
                if (!$scope.isLogged())
                    window.location.replace('/#/login');

                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgError').hide();
                function getClients() {
                    var url = $scope.url+"clients/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200) {
                            $('#divTable').show();
                            $('#msgError').hide();
                            $scope.clientDetail = response.data;
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }
                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#divTable').hide();
                        $('#msgError').show();
                    });
                }
                getClients();

            }
            }).state('updateClient', {
            url: '/updateClient',
            params: {id : null},
            templateUrl    : 'app/pages/utilisateurs/clients/updateClient/updateClient.html',
            title: 'Mise à jour Client',
            controller: function ($scope, $http, $stateParams, $state) {
                if (!$scope.isLogged())
                    window.location.replace('/#/login');
                if ($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();
                $('#msgError').hide();

                function getClient() {
                    var url = $scope.url+"clients/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200) {
                            $scope.client = response.data;
                            $('#divTable').show();
                            $('#msgError').hide();
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }
                    }, function errorCallback(response) {
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#Loaderdiv').hide();
                        $('#divTable').hide();
                        $('#msgError').show();
                    });
                }
                getClient();


                $scope.updateClient = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    var data_client = {
                        deactivated : $scope.booleanToInteger($scope.deactivateMdl),
                        ERP_code    : $scope.codeMdl
                    };
                    var url = $scope.url+"clients/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'PUT',
                        url: url,
                        data :  $.param(data_client),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200) {
                            window.location.replace('/#/utilisateurs/clients');
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_update_client = $scope.getErrorMessage(response);
                    });
                }

                $scope.checkCode = function(val) {
                    $scope.codeMdl = val ;
                }
                $scope.checkDeactivate = function(val) {
                    $scope.deactivateMdl = val ;
                }

            }
        }).state('addClient', {
            url: '/addClient',
            templateUrl: 'app/pages/utilisateurs/clients/addClient/addClient.html',
            title: 'Ajouter Client',
            controller: function ($scope, $http, $stateParams, $state) {
                if (!$scope.isLogged())
                    window.location.replace('/#/login');

                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();

                $scope.addClient = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    var data_client = {
                        deactivated : $scope.booleanToInteger($scope.deactivateMdl),
                        ERP_code    : $scope.codeMdl
                    };
                    var url = $scope.url+"clients";
                    $http({
                        method: 'POST',
                        url: url,
                        data :  $.param(data_client),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                        if(response.status == 200) {
                            window.location.replace('/#/utilisateurs/clients');
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_add_client = $scope.getErrorMessage(response);
                    });
                }
                $scope.checkCode = function(val) {
                    $scope.codeMdl = val ;
                }
                $scope.checkDeactivate = function(val) {
                    $scope.deactivateMdl = val ;
                }

            }
        });
    }

})();
